﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;

//Randomizer is a static class used to implement SPRNGs and achieve determinism
public static class Randomizer
{
    private static int _CurrentSeed;
    public static System.Random RNG { get; private set; } = new System.Random();

    /// <summary>
    /// Initializes the randomizer functionality with an initial starting seed
    /// </summary>
    /// <param name="initialSeed">The initial seed to start</param>
    public static void Initialize(int initialSeed)
    {
        //Set up our current seed, create the RNG object and regenerate
        _CurrentSeed = initialSeed;
        RNG = new System.Random(_CurrentSeed);
        Regenerate();
    }

    /// <summary>
    /// Regenerates the RNG with a new derived seed
    /// </summary>
    public static void Regenerate()
    {
        //System.Random tends toward int.MaxValue.
        //If we're within 10% of it, let's divide by 2 to stay within a decent range
        if(_CurrentSeed >= (int.MaxValue / 100) * 90)
        {
            _CurrentSeed /= 2;
        }

        _CurrentSeed = RNG.Next(_CurrentSeed, int.MaxValue);
        RNG = new System.Random(_CurrentSeed);
    }
}
